<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    * 
    * questo file contiene una serie di funzioni specifiche per il componente e-commerce. Alcune di queste funzioni 
    * sono usate sul backend, altre sul frontend
    * 
    */
    
    function stampaZoneDisagiate($geecomDb) {
        $query = "SELECT * FROM geecEc_zoneDisagiate";
        $ris   = $geecomDb->eseguiQueryLettura($query);
        while($zona = $ris->fetch_assoc()) {
            echo"<div id=\"zonaDisagiata{$zona["id"]}\" class=\"col-sm-6 col-lg-4\">
                    <div class=\"card-body mb-3 py-1 px-2 bg-light border rounded d-sm-flex justify-content-between align-items-center text-center\">
                        <div class=\"mb-1 mb-sm-0 text-muted w-50 text-left\">
                            <p class=\"mb-0\"><em><strong>{$zona["nome"]}</strong></em></p>
                        </div>
                        <div class=\"azioni d-flex align-items-center justify-content-end\">
                            <div class=\"btn-group\" role=\"group\" aria-label=\"Basic example\">
                                <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Modifica\" onclick=\"modificaZonaDisagiata({$zona["id"]},'{$zona["nome"]}','{$zona["capInizio"]}','{$zona["capFine"]}')\"><i class=\"fas fa-edit\"></i></button>
                                <button type=\"button\" class=\"btn btn-light elimina\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Elimina\" onclick=\"eliminaOpzioneSpedizione({$zona["id"]},'zonaDisagiata','{$zona["nome"]}')\" ><i class=\"far fa-trash-alt\"></i></button>
                            </div>
                       </div>
                    </div>
                </div>";
        }
    }
    
    function stampaAreeGeografiche($geecomDb) {
        $query = "SELECT * FROM geecEc_areeGeografiche";
        $ris   = $geecomDb->eseguiQueryLettura($query);
        while($area = $ris->fetch_assoc()) {
            echo"<div id=\"areaGeografica{$area["id"]}\" class=\"col-sm-6 col-lg-4\">
                    <div class=\"card-body mb-3 py-1 px-2 bg-light border rounded d-sm-flex justify-content-between align-items-center text-center\">
                        <div class=\"mb-1 mb-sm-0 text-muted w-50 text-left\">
                            <p class=\"mb-0\"><em><strong>{$area["nome"]}</strong></em></p>
                        </div>
                        <div class=\"azioni d-flex align-items-center justify-content-end\">
                            <div class=\"btn-group\" role=\"group\" aria-label=\"Basic example\">
                                <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Modifica\" onclick=\"modificaAreaGeografica({$area["id"]},'{$area["nome"]}','{$area["nazioni"]}')\"><i class=\"fas fa-edit\"></i></button>
                                <button type=\"button\" class=\"btn btn-light elimina\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Elimina\" onclick=\"eliminaOpzioneSpedizione({$area["id"]},'areaGeografica','{$area["nome"]}')\" ><i class=\"far fa-trash-alt\"></i></button>
                            </div>
                       </div>
                    </div>
                </div>";
        }
    }
  
    /* stampa il singolo prodotto nella colonna
     * $dimensioneDiv indica la dimensione in colonne del div del prodotto a seconda se il prodotto
     * viene messo sulla prima riga ($dimensioneDiv sarà = a 4) o sulla seconda (in questo caso sarà 3)
     * 
     * il campo id può avere diversi valori: se il campo tipo ha valore "singoloProdotto" indica un id
     * di un articolo, altrimenti indica l'id di una categoria
     */
    function stampaSingoloProdotto($geecomDb,$tipoProdotti,$id,$dimensioneDiv) {
        if($tipoProdotti=="casuali") {
            $query="SELECT * FROM geecEc_prodotti WHERE categoria='{$id}' ORDER BY RAND() LIMIT 1";
        }
        else if($tipoProdotti=="singoloProdotto") {
            $query="SELECT * FROM geecEc_prodotti WHERE id='{$id}'";                    
        }
        else {
            $query="SELECT * FROM geecEc_prodotti WHERE categoria='{$id}' ORDER BY RAND() LIMIT 1";
        }
        $risProdotto = $geecomDb->eseguiQueryLettura($query);
        $prodotto = $risProdotto->fetch_assoc();

        $descrizione = explode("<!-- leggi tutto -->",$prodotto["descrizione"]);
        $immagineProdotto = $prodotto["immagine"];

        //stampa il primo prodotto
        echo"<div class=\"col-sm-$dimensioneDiv \">
        <div class=\"thumbnail relative noOverflow\">";
        
        if($prodotto["prezzoOfferta"]>0) {
            echo"<span class=\"ribbon\"><span>Offerta!</span></span>";
        }
        
        echo"<a href=\"prodotto.php?id={$prodotto['id']}&alias={$prodotto['alias']}\"><img class=\"center-block\" img src=\"{$immagineProdotto}\" alt=\"{$prodotto['nome']}\"></a>
         <h2>{$prodotto['nome']}</h2>";
         
        if($prodotto["prezzoOfferta"]>0) {
            echo"<div class=\"extraspace-bottom\"><strong>Prezzo:</strong> {$prodotto["prezzoOfferta"]} €</div>";
        }
        else {
            echo"<div class=\"extraspace-bottom\"><strong>Prezzo:</strong> {$prodotto["prezzo"]} €</div>";
        }
        
        echo"<p>
         <a class=\"btn btn-block btn-default\" href=\"prodotto.php?id={$prodotto['id']}&alias={$prodotto['alias']}\" role=\"button\"><span class=\"glyphicon glyphicon-zoom-in\"></span>Dettagli</a>
         <a class=\"btn btn-block btn-primary\" href=# onclick=\"return aggiungiAlCarrello({$prodotto['id']})\" role=\"button\"><span class=\"glyphicon glyphicon-shopping-cart\"></span>Aggiungi al carrello</a>
         </p>
         </div>
       </div>";
    }
    
    function stampaEtichettaProdotto($etichetta,$valore) {
        $unitaDiMisura = "";
        if($etichetta=="Altezza" || $etichetta=="Larghezza" || $etichetta=="Profonità") {
            $unitaDiMisura = "(cm)";
        }
        else if($etichetta=="Peso") {
            $unitaDiMisura = "(kg)";
        }
        else if($etichetta=="Capacità") {
            $unitaDiMisura = "(l)";
        }
	echo"<tr>
            <td class=\"text-nowrap\"><b>$etichetta $unitaDiMisura</b></td>
            <td style=\"width:100%\">$valore</td>
        </tr>";
    }
    
    function recuperaImpostazioniEmail($geecomDb) {
	$queryimpostazioni = "SELECT * FROM geecAd_impostazioni WHERE id=1";
	$risimpostazioni = $geecomDb->eseguiQueryLettura($queryimpostazioni);
	$impostazioni = $risimpostazioni->fetch_assoc();
	return $impostazioni;
    }
    
    /*
     * Questa funzione restituisce true se il cap passato in input si trova in una zona disagiata, false altrimenti
     * 
     * usata dalle classi Carrello e PaginaCarrello
     */
    function capInZonaDisagiata($geecomDb,$cap) {
        if($cap!="") {
            $query = "SELECT * FROM `geecEc_zoneDisagiate` WHERE capInizio<=$cap AND capFine>=$cap";
            $ris   = $geecomDb->eseguiQueryLettura($query);
            
            if($ris->num_rows>0) {
                return true;
            }
            else {
                return false;
            }
        }
        else {
            return false;
        }
    }